<?php
namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * VM\ApiBundle\Entity\RDFExport
 *
 * @ORM\Table(name="rdf_exports")
 * @ORM\Entity()
 *
 * @ExclusionPolicy("all")
 */
class RDFExport
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="round_id", type="integer")
     */
    private $roundId;

    /**
     * @var integer
     *
     * @ORM\Column(name="company_id", type="integer")
     */
    private $companyId;

    /**
     * @var text
     *
     * @ORM\Column(name="export_data", type="text")
     */
    private $export_data;

    /**
     * @var text
     *
     * @ORM\Column(name="export_type", type="text")
     */
    private $export_type;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="createAt", type="datetime")
     */
    private $createAt;

    /**
     * @ORM\ManyToOne(targetEntity="Round",inversedBy="summaryCompanyRound")
     * @ORM\JoinColumn(name="round_id", referencedColumnName="id")
     */
    protected $round;

    /**
     * @ORM\ManyToOne(targetEntity="Company",inversedBy="summaryCompanyRound")
     * @ORM\JoinColumn(name="company_id", referencedColumnName="id")
     */
    protected $company;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set roundId
     *
     * @param integer $roundId
     * @return RDFExport
     */
    public function setRoundId($roundId)
    {
        $this->roundId = $roundId;
    
        return $this;
    }

    /**
     * Get roundId
     *
     * @return integer 
     */
    public function getRoundId()
    {
        return $this->roundId;
    }

    /**
     * Set companyId
     *
     * @param integer $companyId
     * @return RDFExport
     */
    public function setCompanyId($companyId)
    {
        $this->companyId = $companyId;
    
        return $this;
    }

    /**
     * Get companyId
     *
     * @return integer 
     */
    public function getCompanyId()
    {
        return $this->companyId;
    }

    /**
     * Set export_data
     *
     * @param string $exportData
     * @return RDFExport
     */
    public function setExportData($exportData)
    {
        $this->export_data = $exportData;
    
        return $this;
    }

    /**
     * Get export_data
     *
     * @return string 
     */
    public function getExportData()
    {
        return $this->export_data;
    }

    /**
     * Set export_type
     *
     * @param string $exportType
     * @return RDFExport
     */
    public function setExportType($exportType)
    {
        $this->export_type = $exportType;
    
        return $this;
    }

    /**
     * Get export_type
     *
     * @return string 
     */
    public function getExportType()
    {
        return $this->export_type;
    }

    /**
     * Set round
     *
     * @param \VM\ApiBundle\Entity\Round $round
     * @return RDFExport
     */
    public function setRound(\VM\ApiBundle\Entity\Round $round = null)
    {
        $this->round = $round;
    
        return $this;
    }

    /**
     * Get round
     *
     * @return \VM\ApiBundle\Entity\Round 
     */
    public function getRound()
    {
        return $this->round;
    }

    /**
     * Set company
     *
     * @param \VM\ApiBundle\Entity\Company $company
     * @return RDFExport
     */
    public function setCompany(\VM\ApiBundle\Entity\Company $company = null)
    {
        $this->company = $company;
    
        return $this;
    }

    /**
     * Get company
     *
     * @return \VM\ApiBundle\Entity\Company 
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * Set createAt
     *
     * @param \DateTime $createAt
     * @return RDFExport
     */
    public function setCreateAt($createAt)
    {
        $this->createAt = $createAt;
    
        return $this;
    }

    /**
     * Get createAt
     *
     * @return \DateTime 
     */
    public function getCreateAt()
    {
        return $this->createAt;
    }
}